<?php
/**
 * @name		Mobile Menu CK
 * @copyright	Copyright (C) 2017. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */
 
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Mobilemenuck\CKView;
use Mobilemenuck\CKFof;

class MobilemenuckViewStyles extends CKView {

	protected $toolbar;

	public function display($tpl = null) {
		$user = \Joomla\CMS\Factory::getUser();
		$authorised = ($user->authorise('core.edit', 'com_mobilemenuck') || (count($user->getAuthorisedCategories('com_mobilemenuck', 'core.edit'))));

		if ($authorised !== true)
		{
			throw new Exception(\Joomla\CMS\Language\Text::_('JERROR_ALERTNOAUTHOR'), 403);
			return false;
		}

		// for the items published to be shown in the modal list
		$this->state = $this->model->getState();
		if ($this->input->get('layout') === 'modal') {
			$this->model->setState('filter_state', '1');
		} else {
			$this->model->setState('filter_state', '');
		}

		$this->items = $this->get('Items');

		$this->toolbar = $this->getToolbar();

		// Load the left sidebar.
		MobilemenuckHelper::addSubmenu();

		// Load the title
		\Joomla\CMS\Toolbar\ToolbarHelper::title(\Joomla\CMS\Language\Text::_('COM_MOBILEMENUCK') . ' - ' . \Joomla\CMS\Language\Text::_('CK_STYLES_LIST'), 'logo_mobilemenuck_large.png');

		if (CKFof::isAdmin()) $this->addToolbar();

		parent::display($tpl);
	}

	
	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar() {
		MobilemenuckHelper::loadCkbox();

		// Get the toolbar object instance
		$bar = \Joomla\CMS\Toolbar\Toolbar::getInstance('toolbar');

		if (CKFof::userCan('create')) {
			// \Joomla\CMS\Toolbar\ToolbarHelper::addNew('style.add', 'CK_NEW');
			if ($this->input->get('modal') == '1') {
				\Joomla\CMS\Toolbar\ToolbarHelper::addNew('style.add', 'CK_NEW');
			} else {
				$html = '<button class="btn btn-small btn-success" onclick="CKBox.open({handler:\'iframe\', fullscreen: true, url:\'' . \Joomla\CMS\Uri\Uri::root(true) . '/administrator/index.php?option=com_mobilemenuck&view=style&tmpl=component&id=0\'})">
						<span class="icon-new icon-white"></span>
						' . \Joomla\CMS\Language\Text::_('JTOOLBAR_NEW') . '
						</button>';
				$bar->appendButton('Custom', $html);
			}
		}
		if (CKFof::userCan('edit')) {
			\Joomla\CMS\Toolbar\ToolbarHelper::custom('style.copy', 'copy', 'copy', 'CK_COPY');
		}
		if (CKFof::userCan('delete')) {
			//If this component does not use state then show a direct delete button as we can not trash
			\Joomla\CMS\Toolbar\ToolbarHelper::trash('style.delete');
		}
	}

	private function getToolbar() {
		// Get the toolbar object instance
		$bar = \Joomla\CMS\Toolbar\Toolbar::getInstance('toolbar');

		return $bar;
	}
}
