<?php
/**
 * @name		Mobile Menu CK
 * @copyright	Copyright (C) 2017. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */
 
// No direct access
defined('_JEXEC') or die;

use Mobilemenuck\CKView;
use Mobilemenuck\CKFof;

class MobilemenuckViewMenu extends CKView {

	function display($tpl = null) {
		$user = \Joomla\CMS\Factory::getUser();
		$authorised = ($user->authorise('core.edit', 'com_mobilemenuck') || (count($user->getAuthorisedCategories('com_mobilemenuck', 'core.edit'))));

		if ($authorised !== true)
		{
			throw new Exception(\Joomla\CMS\Language\Text::_('JERROR_ALERTNOAUTHOR'), 403);
			return false;
		}

		// dislay the page title
		\Joomla\CMS\Toolbar\ToolbarHelper::title(\Joomla\CMS\Language\Text::_('COM_MOBILEMENUCK') . ' - ' . \Joomla\CMS\Language\Text::_('CK_MENU_EDITION'), 'logo_mobilemenuck_large.png');

		// loads the language files from the plugin
		$lang	= \Joomla\CMS\Factory::getLanguage();
		$lang->load('plg_system_mobilemenuck', JPATH_SITE . '/plugins/system/mobilemenuck', $lang->getTag(), false);
		$lang->load('plg_system_mobilemenuck', JPATH_ADMINISTRATOR, $lang->getTag(), false);

		// load the styles helper and the interface
		require_once MOBILEMENUCK_ADMIN_PATH . '/helpers/ckstyles.php';
		require_once MOBILEMENUCK_ADMIN_PATH . '/helpers/ckinterface.php';
		require_once MOBILEMENUCK_ADMIN_PATH . '/helpers/ckfields.php';

		$this->item = $this->get('Data');
		$this->interface = new CKInterface();
		$this->fields = new CKFields();

		if (\Joomla\CMS\Factory::getApplication()->isClient('administrator')) $this->addToolbar();
		parent::display($tpl);
	}


	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar() {
		MobilemenuckHelper::loadCkbox();

		$bar = \Joomla\CMS\Toolbar\Toolbar::getInstance('toolbar');
		if (CKFof::userCan('create')) {
			$html = '<button class="btn btn-small btn-success" onclick="ckSaveMenu()">
					<span class="icon-apply icon-white"></span> ' . CKText::_('CK_SAVE') . '
					</button>';
			$bar->appendButton('Custom', $html);
			\Joomla\CMS\Toolbar\ToolbarHelper::cancel('menus.cancel');
		}
	}
}
