<?php
/*
 * @package   onthos
 * @copyright Copyright (c) 2024-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Component\Onthos\Administrator\Library\Issues;

use Akeeba\Component\Onthos\Administrator\Helper\AdoptionHelper;
use Akeeba\Component\Onthos\Administrator\Library\CoreExtensions;
use Akeeba\Component\Onthos\Administrator\Library\Extension\ExtensionInterface;
use Psr\Log\LogLevel;

defined('_JEXEC') || die;

/**
 * Obsolete Core Extension.
 *
 * This extension used to be shipped with Joomla, but not anymore.
 *
 * @since   1.0.0
 */
class ObsoleteCore extends AbstractIssue implements IssueInterface
{
	/**
	 * @inheritdoc
	 * @since  1.0.0
	 */
	public function __construct(ExtensionInterface $extension)
	{
		parent::__construct($extension);

		$this->defaultSeverity = LogLevel::ERROR;
	}


	/**
	 * @inheritdoc
	 * @since  1.0.0
	 */
	public function doTest(): bool
	{
		/**
		 * The English language pack is installed as a core extension, but is not part of the installation SQL since
		 * Joomla! 4. As a result, it always appears as out of date even though it can never be out of date. Hence this
		 * ugly workaround.
		 */
		if ($this->extension->type === 'language' && $this->extension->element === 'en-GB')
		{
			return false;
		}

		return CoreExtensions::isTooOld($this->extension);
	}

	/**
	 * @inheritdoc
	 * @since  1.0.0
	 */
	public function getDetailsTemplate(): string
	{
		return 'issues/obsolete_core';
	}
}