<?php
/**
 * @name		Mobile Menu CK
 * @copyright	Copyright (C) 2017. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */
 
// No direct access
defined('_JEXEC') or die;

use Mobilemenuck\CKView;
use Mobilemenuck\CKFof;

class MobilemenuckViewStyle extends CKView {

	protected $interface;

	function display($tpl = null) {
		$user = \Joomla\CMS\Factory::getUser();
		$authorised = ($user->authorise('core.edit', 'com_mobilemenuck') || (count($user->getAuthorisedCategories('com_mobilemenuck', 'core.edit'))));

		if ($authorised !== true)
		{
			throw new Exception(\Mobilemenuck\CKText::_('JERROR_ALERTNOAUTHOR'), 403);
			return false;
		}

		// dislay the page title
		\Joomla\CMS\Toolbar\ToolbarHelper::title(\Mobilemenuck\CKText::_('COM_MOBILEMENUCK') . ' - ' . \Mobilemenuck\CKText::_('CK_STYLES_EDITION'), 'logo_mobilemenuck_large.png');

		// load the styles helper and the interface
		require_once JPATH_SITE . '/administrator/components/com_mobilemenuck/helpers/ckstyles.php';
		require_once(JPATH_SITE . '/administrator/components/com_mobilemenuck/helpers/ckinterface.php');

		$this->interface = new CKInterface();
		$this->item = $this->get('Item');

		// force the layout
		$this->input->set('tmpl', 'component');

//		if (\Mobilemenuck\CKFof::getApplication()->isClient('administrator')) $this->addToolbar();
		parent::display($tpl);
	}

	protected function render_previewmenu() {
		?>
		<div id="mobilemenuck-preview-mobile-bar" class="mobilemenuck-bar" style="display:block;">
			<span class="mobilemenuck-bar-title">Menu</span>
			<div class="mobilemenuck-bar-button" onclick="jQuery('#mobilemenuck-preview-mobile-bar').hide();jQuery('#mobilemenuck-preview-mobile').show();">&#x2261;</div>
		</div>
		<div id="mobilemenuck-preview-mobile" class="mobilemenuck" style="position: relative !important; z-index: 100000; display: none;">
				<div class="mobilemenuck-topbar">
					<span class="mobilemenuck-title">Menu</span>
					<span class="mobilemenuck-button" onclick="jQuery('#mobilemenuck-preview-mobile').hide();jQuery('#mobilemenuck-preview-mobile-bar').show();">×</span>
				</div>
				<div class="mobilemenuck-item">
					<div class="maximenuck first level1 ">
						<a href="javascript:void(0)">
							<span class="mobiletextck">Lorem</span>
						</a>
					</div>
				</div>
				<div class="mobilemenuck-item">
					<div class="maximenuck parent level1">
						<a href="javascript:void(0)">
							<span class="mobiletextck">Ipsum</span>
						</a>
					</div>
					<div class="mobilemenuck-submenu">
						<div class="mobilemenuck-item">
							<div class="maximenuck parent first level2 ">
								<a href="javascript:void(0)">
									<span class="mobiletextck">Dolor sit</span>
								</a>
							</div>
							<div class="mobilemenuck-submenu">
								<div class="mobilemenuck-item">
									<div class="maximenuck first level3 ">
										<a href="javascript:void(0)">
											<span class="mobiletextck">Consectetur</span>
										</a>
									</div>
								</div>
								<div class="mobilemenuck-item">
									<div class="maximenuck last level3 ">
										<a href="javascript:void(0)">
											<span class="mobiletextck">Adipiscing</span>
										</a>
									</div>
								</div>
							</div>
						</div>
						<div class="mobilemenuck-item">
							<div class="maximenuck parent level2 ">
								<a href="javascript:void(0)">
									<span class="mobiletextck">Sed maximus</span>
								</a>
							</div>
							<div class="mobilemenuck-submenu">
								<div class="mobilemenuck-item">
									<div class="maximenuck first level3 ">
										<a href="javascript:void(0)">
											<span class="mobiletextck">Vivamus</span>
										</a>
									</div>
								</div>
								<div class="mobilemenuck-item">
									<div class="maximenuck level3 ">
										<a href="javascript:void(0)">
											<span class="mobiletextck">Fusce porta</span>
										</a>
									</div>
								</div>
								<div class="mobilemenuck-item">
									<div class="maximenuck last level3 ">
										<a href="javascript:void(0)">
											<span class="mobiletextck">Pellentesque</span>
										</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<div class="mobilemenuck-item">
					<div class="maximenuck parent level1 accordionmobileck">
						<a href="javascript:void(0)">
							<span class="mobiletextck">Maecenas</span>
						</a>
						<div class="mobilemenuck-togglericon" onclick="jQuery(this).parent().toggleClass('open')"></div>
					</div>
					<div class="mobilemenuck-submenu">
						<div class="mobilemenuck-item">
							<div class="maximenuck parent first level2 accordionmobileck">
								<a href="javascript:void(0)">
									<span class="mobiletextck">Vel convallis</span>
								</a>
								<div class="mobilemenuck-togglericon" onclick="jQuery(this).parent().toggleClass('open')"></div>
							</div>
							<div class="mobilemenuck-submenu">
								<div class="mobilemenuck-item">
									<div class="maximenuck first level3 ">
									<a href="javascript:void(0)">
									<span class="mobiletextck">Facilisis</span>
									</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="mobilemenuck-item">
					<div class="maximenuck first level1 headingck">
						<a href="javascript:void(0)">
							<span class="mobiletextck">Heading</span>
						</a>
					</div>
				</div>
			</div>
		<?php
	}
}
