<?php
/**
 * @name		Mobile Menu CK
 * @copyright	Copyright (C) 2017. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

// No direct access.
defined('_JEXEC') or die;

use Mobilemenuck\CKModel;
use Mobilemenuck\CKFof;
use Mobilemenuck\CKObject;

class MobilemenuckModelMenu extends CKModel {

	protected $table = '#__mobilemenuck_menus';

	var $_item = null;

	public function &getData($id = null) {
		$input = \Mobilemenuck\CKFof::getInput();
		$id = $input->get('id', $id, 'int');
		$db = \Mobilemenuck\CKFof::getDbo();
		if ($this->_item === null) {
			if ($id) {
				$this->_item = new stdClass();
				$db->setQuery('SELECT * FROM #__mobilemenuck_menus WHERE id=' . (int) $id);
				$this->_item = $db->loadObject();
				$this->_item->params =  new CKObject(unserialize($this->_item->params));
			} else {
				$this->_item = new stdClass();
				$this->_item->id = 0;
				$this->_item->name = '';
				$this->_item->state = '1';
				$this->_item->params = new CKObject();
				$this->_item->type = '';
				$this->_item->style = '';
			}
		}

		return $this->_item;
	}

	public function &getItem($id = null) {
		$app = \Mobilemenuck\CKFof::getApplication();
		if ($this->_item === null) {
			$this->_item = false;

			if (empty($id)) {
				$id = $app->input->get('id', 0, 'int');
			}

//			\Joomla\CMS\Table\Table::addIncludePath(MOBILEMENUCK_ADMIN_PATH . '/tables');
//			$row = \Joomla\CMS\Table\Table::getInstance('Styles', 'MobilemenuckTable');
			$table = $this->getTable();

			// Attempt to load the row.
			if ($table->load((int)$id)) {
				// Check published state.
				if ($published = $this->getState('filter.published')) {
					if ($table->state != $published) {
						return $this->_item;
					}
				}

				// Convert the \Joomla\CMS\Table\Table to a clean \Mobilemenuck\CKObject.
				$properties = $table->getProperties(1);
				$this->_item = \Joomla\Utilities\ArrayHelper::toObject($properties, '\Mobilemenuck\CKObject');
				$this->_item->params =  new CKObject(unserialize($this->_item->params));
			} elseif ($error = $table->getError()) {
				$this->setError($error);
			}
		}

		return $this->_item;
	}

	public function save($data) {
		$input = \Mobilemenuck\CKFof::getApplication()->input;
		$id = (!empty($data['id'])) ? $data['id'] : (int) $this->getState('menu.id');
		$user = \Joomla\CMS\Factory::getUser();
		
//		if (isset($data['options']) && is_array($data['options']))
//		{
//			$registry = new Registry;
//			$registry->loadArray($data['options']);
//			$data['params'] = (string) $registry;
//		}

		if ($id) {
			//Check the user can edit this item
			$authorised = $user->authorise('core.edit', 'menu.' . $id);
		} else {
			//Check the user can create new items in this section
			$authorised = $user->authorise('core.create', 'com_mobilemenuck');
		}

		if ($authorised !== true) {
			throw new Exception(\Mobilemenuck\CKText::_('JERROR_ALERTNOAUTHOR'), 403);
			return false;
		}

		// $table = $this->getTable();
		// $table->load($data['id']);

		$data['params'] = serialize($data['params']);

		$result = CKFof::dbStore('#__mobilemenuck_menus', $data);
		return $result;
		// if ($table->save($data) === true) {
			// return $table->id;
		// } else {
			// return false;
		// }
	}

	function copy($id = null) {

		$row = $this->getTable();
		$cid = \Mobilemenuck\CKFof::getApplication()->input->get('id', '', 'array');
		$pk = isset($cid[0]) ? (int) $cid[0] : $id;
		$table = $this->getTable();

		// Attempt to load the row.
		$table->load((int)$id);
		$table->id = 0;

		// give the new name
		$table->name .= '-copy';
		$data->state = 0;

		// Bind the form fields to the table
		if (!$row->bind($table)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// Make sure the record is valid
		if (!$row->check()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// Store the table to the database
		if (!$row->store()) {
			$this->setError($row->getErrorMsg());
			return false;
		}

		// $this->setId($row->id);

		return true;
	}

}