<?php
/**
 * @name		Extensions Manager CK
 * @package		com_extensionsmanagerck
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

defined('_JEXEC') or die;

\Joomla\CMS\HTML\HTMLHelper::_('jquery.framework');

$doc = \Extensionsmanagerck\CKFof::getDocument();
$config = \Joomla\CMS\Component\ComponentHelper::getParams('com_extensionsmanagerck');
$user  = \Joomla\CMS\Factory::getUser();

$doc->addStylesheet(\Extensionsmanagerck\CKUri::root(true) . '/administrator/components/com_extensionsmanagerck/assets/ckbox.css');
$doc->addStylesheet(\Extensionsmanagerck\CKUri::root(true) . '/administrator/components/com_extensionsmanagerck/assets/ckframework.css?ver=1.2.0');
$doc->addStylesheet(\Extensionsmanagerck\CKUri::root(true) . '/administrator/components/com_extensionsmanagerck/assets/extensionsmanagerck.css?ver=1.2.0');

$doc->addScript(\Extensionsmanagerck\CKUri::root(true) . '/administrator/components/com_extensionsmanagerck/assets/ckbox.js');
$doc->addScript(\Extensionsmanagerck\CKUri::root(true) . '/administrator/components/com_extensionsmanagerck/assets/extensionsmanagerck.js?ver=1.2.0');
$doc->addScriptDeclaration('jQuery(document).ready(function (){
	// check the release notes
	ckGetLanguagesData();
});');
$input = \Extensionsmanagerck\CKFof::getApplication()->input;

?>
<div class="ckwell">
<h1><?php echo \Extensionsmanagerck\CKText::_('CK_PACK_ALLINONE'); ?> <small><a href="https://www.joomlack.fr/en/pack-all-extensions" target="_blank"><?php echo \Extensionsmanagerck\CKText::_('CK_GETITHERE'); ?></a></small></h1>
<p><?php echo \Extensionsmanagerck\CKText::_('CK_PACK_ALLINONE_DESC'); ?></p>
</div>

<div class="ckwell">
	<h2><a href="https://translations.joomlack.fr/" target="_blank"><?php echo \Extensionsmanagerck\CKText::_('CK_CONTRIBUTE'); ?></a></h2>
</div>

<div class="well">
ALL extensions already have the French fr-FR and English en-GB languages installed.
</div>
<select id="languagesSelector" onchange="ckFilterByLang(this.value)">
	<option value="-1">Filter by language</option>
</select>
<table class="table table-stripe" id="languagesList">
	<thead>
		<tr>
			<th class="left" style="width: 200px;">
				<?php echo \Extensionsmanagerck\CKText::_('CK_NAME'); ?>
			</th>

			<th class="">

			</th>
		</tr>
	</thead>
	<tbody>
		<?php
		foreach ($this->items as $i => $item) :
			if (isset($item->slug)) {
				?>
				<tr class="row<?php echo $i % 2; ?> ckextension" 
					data-slug="<?php echo $item->slug ?>"
					>
					
					<td>
						<?php echo " - " . $item->name; ?>
					</td>
					
					
				</tr>
			<?php } ?>
		<?php endforeach; ?>
		<tr class="row<?php echo ($i+1) % 2; ?> ckextension" 
			data-slug="template-creator-ck"
			>
			<td>
				- Template Creator CK
			</td>
			
			
		</tr>
	</tbody>
</table>

<div id="ckmessagespopup"></div>
