/**
 * @name		Extensions Manager CK
 * @package		com_extensionsmanagerck
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

var $ck = jQuery.noConflict();



function ckloadAllData(reload) {
	if (! reload) reload = false;
	var toolbarBtn = jQuery('#toolbar-ckloadAllData > button > span');
	toolbarBtn.attr('ckloading', 0).attr('class', 'icon-').addClass('ckwait');
	jQuery('.ckextension').each(function() {
		toolbarBtn.attr('ckloading', parseInt(toolbarBtn.attr('ckloading')) + 1);
		// ckGetExtensionData(this, reload);
	});
		ckGetExtensionData(reload);
}

function ckGetLicenseData(reload) {
	if (! reload) reload = false;

	jQuery.ajax({
		type: "POST",
		url: "https://www.joomlack.fr/?option=com_dms&task=loadlicense",
		jsonpCallback: "ckExtensionsManagerLicense",
		cache: ! reload,
		timeout: 20000,
		dataType: "jsonp",
		data: {
			format: 'jsonp',
			referrer: window.location.hostname,
			license: jQuery('#license_code').val()
		}
	}).done(function(response) {
		
		var days = response['days'];
		var expired = response['expired'];
		var htmlexpired = '<span class="ckbadge ckbadge-important">' + Joomla.JText._('CK_LICENSE_EXPIRED') + '</span>';
		var htmldays = '<span class="ckbadge ckbadge-success">' + Joomla.JText._('CK_LICENSE_DAYS_LEFT') + ' : <span class="cklicense-days">[DAYS]</span></span>';
		for (var i=0; i<expired.length; i++) {
			var eid = expired[i];
			if (eid == 'all') {
				jQuery('tr[data-downloadid="153"]').find('td.cklicense').html(htmlexpired);
			} else 
			if (eid) {
				jQuery('tr[data-downloadid="' + eid + '"]').find('td.cklicense').html(htmlexpired);
			}
		}
		if (days['all'] && days['all'].item_days_diff_end > 0) {
			jQuery('tr[data-downloadid="153"]').attr('data-active', '1').find('td.cklicense').html(htmldays.replace('[DAYS]', days['all'].item_days_diff_end));
			jQuery('.ckpurchasebtn').hide();
			jQuery('tr.ckextension[data-update="1"]').find('.ckupdatebtn').show();
			jQuery('tr.ckextension[data-update="1"]').find('.ckinstallbtn').hide();
		} else {
			// console.log(days);
			jQuery('tr.ckextension').each(function() {
				var extRow = $ck(this);
				var extId = extRow.attr('data-downloadid');
				// all in one pack
				// if (extId == '153') {
					
				// }
				// paid extensions
				if (extRow.attr('data-ispaid') == '1') {
					// active license
					if (days[extId] && days[extId] > 0) {
						extRow.find('td.cklicense').html(htmldays.replace('[DAYS]', days[extId]));
						// installed
						if (extRow.attr('data-installed') == '1') {
							extRow.find('.ckupdatebtn').show();
							extRow.find('.ckpurchasebtn').hide();
							extRow.find('.ckinstallbtn').hide();
//							extRow.append('TEST pro installed ');
						} 
						// not installed
						else {
							extRow.find('.ckupdatebtn').hide();
							extRow.find('.ckpurchasebtn').hide();
							extRow.find('.ckinstallbtn').show();
//							extRow.append('TEST pro NOT installed ');
						}
					// no license
					} else {
						extRow.find('.ckupdatebtn').hide();
						extRow.find('.ckpurchasebtn').show();
						extRow.find('.ckinstallbtn').hide();
//						extRow.append('TEST no licence ');
					}
				} 
				// free extensions
				else {
					extRow.find('.ckinstallbtnpro').hide();
//					extRow.append('TEST light ');
				}
			});
			// ckextension
			// for (var id in days) {
				// if (days[id]) {
					// eid = id;
					// if (id == 'all') eid = '153';
					// var extRow = jQuery('tr[data-downloadid="' + eid + '"]');
					// if (days[id] > 0) {
						// extRow.find('td.cklicense').html(htmldays.replace('[DAYS]', days[id]));
						// if (extRow.attr('data-installed')) {
							// extRow.find('.ckinstallbtn').show();
							// extRow.find('.ckpurchasebtn').hide();
						// }
					// } else {
						// jQuery('tr[data-downloadid="' + eid + '"]').find('td.cklicense').html(htmlexpired);
						// extRow.find('.ckupdatebtn').show();
					// }
				// }
			// }
		}
		
		if (response['licensestate'] == '1') {
			document.getElementById('license_code').setAttribute('data-valid', '1');
			document.getElementById('license_code_valid').style.display = '';
		} else {
			document.getElementById('license_code').setAttribute('data-valid', '0');
			document.getElementById('license_code_notvalid').style.display = '';
			// jQuery('tr.ckextension[data-ispaid="1"]').find('.ckpurchasebtn').show();
			// jQuery('tr.ckextension[data-ispaid="1"]').find('.ckupdatebtn').hide();
			// jQuery('tr.ckextension[data-ispaid="1"]').find('.ckinstallbtn').hide();
		}
		// if pack all in one active
		if (days['all'] && days['all'].item_days_diff_end > 0 && jQuery('tr[data-downloadid="153"]').attr('data-active') == '1') {
			$ck('.ckpurchasebtn').hide();
			$ck('[data-installed="1"][data-update="1"]').find('.ckupdatebtn').show();
			$ck('[data-installed="0"]').find('.ckinstallbtn').show();
			$ck('tr:not([data-downloadid="153"]) td.cklicense').html('');
		}
	}).fail(function( jqxhr, textStatus, error ) {
		var err = textStatus + ", " + error;
		console.error( "Request Failed: " + err );
		jQuery('.cklatestversion > span').text('error').addClass('ckbadge-important');
	});
}

function ckGetExtensionData(reload) {
	if (! reload) reload = false;
	var toolbarBtn = jQuery('#toolbar-ckloadAllData > button > span');
	// var jsonFile = jQuery(ext).attr('data-type') + '_' + jQuery(ext).attr('data-element') + '_notes.json';
	jQuery.ajax({
		type: "POST",
		url: "https://update.joomlack.fr/extensions.php",
		// url: "index.php?option=com_extensionsmanagerck&task=ajaxGetFile",
		jsonpCallback: "ckExtensionsManager",
		cache: ! reload,
		timeout: 20000,
		dataType: "jsonp",
		data: {

		}
	}).done(function(response) {
		// ajax request to load the license infos
		ckGetLicenseData(reload);
		jQuery('tr.ckextension').each(function() {
			var $row = jQuery(this);
			var datatype = $row.attr('data-type');
if (! datatype) return;
			var dataelement = $row.attr('data-element');
//			if ($row.attr('data-haspro') === '1') {
//				var name = dataelement + '_notes.json';
//			} else {
//				var name = datatype + '_' + dataelement + '_notes.json';
//			}
			var name = dataelement + '_notes.json';
			if (response[name] === undefined) {
				name = datatype + '_' + dataelement + '_notes.json';
			}
			try {
				var data = JSON.parse(response[name]);
				var infourl = (data.infourl) ? data.infourl : '';
			}
			catch(error) {
				// console.error(error);
				// continue;
			}

			if (datatype !== 'all') {
				if ($row.attr('data-haspro') === '1' && $row.attr('data-ispro') === '1') {
					var version = data.version_pro ? data.version_pro : data.version;
				} else if ($row.attr('data-haspro') === '1' && $row.attr('data-ispro') === '0') {
					var version = data.version_light ? data.version_light : data.version;
				} else {
					// B/C
					var version = data.version;
				}

				$row.find('.cklatestversion > span').text(version);
				if (infourl) {
					jQuery('.ckheading[data-element="' + dataelement + '"]').find('.ckinfourl > a').attr('href', infourl).show();
					jQuery('.ckextension[data-element="' + dataelement + '"]').find('.ckinfourl > a').attr('href', infourl).show();
				}
				if ($row.attr('data-installed')) {
					$row.find('ckinstallbtn').hide();
					// check if the latest version if higher that the current installed version
					var installedversion = $row.find('.ckinstalledversion > .ckversion').text().trim();
					if (compareVersions(version, installedversion)) {
						$row.find('.ckupdatebtn').show();
						$row.find('.ckinstalledversion .ckversion').addClass('ckbadge-warning');
						$row.find('.ckreleasenotesbtn').show();
						var notes = ckGetReleaseNotes(data, installedversion);
						$row.find('.ckreleasenotespopup').empty().append(notes);
						$row.attr('data-update', '1');
					} else {
						if ($row.attr('data-installed') == '1')
							$row.find('.ckinstalledversion .ckversion').addClass('ckbadge-success');
					}
				}
			}
		});

		toolbarBtn.removeClass('ckwait').attr('class', 'icon-ok');
	}).fail(function( jqxhr, textStatus, error ) {
		var err = textStatus + ", " + error;
		console.error( "Request Failed: " + err );
		jQuery('.cklatestversion > span').text('error').addClass('ckbadge-important');
	});
}

function compareVersions(installed, required) {
	var a = installed.split(".");
	var b = required.split(".");

	for (var i = 0; i < a.length; ++i) {
		a[i] = Number(a[i]);
	}
	for (var i = 0; i < b.length; ++i) {
		b[i] = Number(b[i]);
	}
	if (a.length == 2) {
		a[2] = 0;
	}

	if (a[0] > b[0]) return true;
	if (a[0] < b[0]) return false;

	if (a[1] > b[1]) return true;
	if (a[1] < b[1]) return false;

	if (a[2] > b[2]) return true;
	if (a[2] < b[2]) return false;

	return false;
}

function ckGetReleaseNotes(response, installedversion) {
	var notes = '';
	for (var version in response.releasenotes) {
		if (compareVersions(version, installedversion)) {
			notes += writeVersionInfo(response, version);
		}
	}
	return notes;
}

function writeVersionInfo(response, version) {
	var txt = "<div class=\"ckreleasenotes-heading\">";
	txt += "<strong class=\"badge\">Version : " + version + "</strong>";
	txt += " - Date : " + response.releasenotes[version]["date"];
	txt += "</div>";
	txt += "<ul class=\"ckreleasenotes-list\">";
	for (i=0;i<response.releasenotes[version]["notes"].length;i++) {
		txt += "<li>" + response.releasenotes[version]["notes"][i] + "</li>";
	}
	txt += "</ul>";

	return txt;
}

function ckShowReleaseNotes(btn) {
	CKBox.open({handler: 'inline', fullscreen: false, content: jQuery(btn).next().attr('id'), size: {x: '800px', y: '200px'}});
}

function ckInstallExt(btn, pro) {
	if (! pro) pro = false;
	var extRow =  jQuery(jQuery(btn).parents('tr')[0]);
	// if ((extRow.attr('data-ispro') || extRow.attr('data-ispaid')) && $ck('#license_code').attr('data-valid') == '0') {
		// alert('Your license is not valid. You can not install automatically.');
		// return;
	// }
	if (! confirm('Are you sure that you want to install this extension ?')) return;

	// add the wait icon for user information
	extRow.find('.ckupdatebtn').after('<span class="ckwait">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>');
	// extRow.find('.ckinstallbtn').after('<span class="ckwait">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>');

	var download_id = pro ? extRow.attr('data-downloadid-pro') : extRow.attr('data-downloadid');
	// launch the install process
	var install_url = 'https://www.joomlack.fr/index.php?option=com_dms&amp;task=doc_download&amp;updater=true&amp;id=' + download_id;
	jQuery.ajax({
		type: "POST",
		url: "index.php?option=com_extensionsmanagerck&task=ajaxInstallExt",
		data: {
			install_url : install_url
		}
	}).done(function(response) {
		// console.log(response);
		if (response.trim().length) {
			// alert(response);
			$ck('#ckmessagespopup').append(response);
			CKBox.open({handler: 'inline', fullscreen: false
			, content: 'ckmessagespopup'
			, size: {x: '800px', y: '200px'}
			, style: {padding: '10px'}
			,closeText: ''
			,footerHtml: '<a class="ckboxmodal-button" href="javascript:void(0)" onclick="location.reload();">×</a>'});
		} else {
			location.reload();
		}
	}).fail(function( jqxhr, textStatus, error ) {
		var err = textStatus + ", " + error;
		console.log( "Request Failed: " + err );
	});
}

function ckShowUpdater(name) {
	if (! jQuery('#license_code').val()) {
		alert('You must fill the License Code at the top of this page to update your paid extensions');
		return;
	}
	CKBox.open({fullscreen: true, url: 'index.php?option=com_installer&view=update&filter_search=' + name});
}

function ckGetLanguagesData(reload) {
	if (! reload) reload = false;
	var toolbarBtn = jQuery('#toolbar-ckloadAllData > button > span');

	jQuery.ajax({
		type: "POST",
		// url: "index.php?option=com_extensionsmanagerck&task=ajaxGetFile",
		url: "https://translations.joomlack.fr/index.php?option=com_translationsck&task=package.getAll",
		jsonpCallback: "ckExtensionsManager",
		cache: ! reload,
		timeout: 20000,
		dataType: "jsonp",
		data: {

		}
	}).done(function(response) {
		var table = jQuery('#languagesList tbody');
		var langselect = new Array();
		for (var [name, obj] of Object.entries(response)) {
			var html = '<td style="display: flex;flex-wrap: wrap;justify-content: space-between;">';
			var name = obj.title;
			var id = obj.id;
			var slug = obj.slug;
			var langs = obj.infos;
			// html += '<tr><td>' + name + '</td>';

			var row = jQuery('tr.ckextension[data-slug="' + slug + '"]');
			for (var [lang, stats] of Object.entries(langs)) {

				if (lang == 'en-GB' || lang == 'fr-FR' || lang.indexOf('-') == -1) continue;
				html += '<a data-lang="' + lang + '" data-name="' + name + '" data-project-id="' + id + '" class="btn btn-primary">' + lang + ' <span class="ckbadge ckbadge-info">' + stats['completed'] + '%</span></a>';

				if (langselect.indexOf(lang) == -1 && lang.indexOf('-') !== -1) {
					langselect.push(lang);
				}
			}
			html += '</td>';
			row.append(html);
		}
		// table.append(html);
		langselect = langselect.sort();
		for (var i=0; i<langselect.length; i++) {
			jQuery('#languagesSelector').append('<option value="' + langselect[i] + '">' + langselect[i] + '</option>');
		}
		jQuery('a[data-lang]').click(function() {
			ckLoadLanguagePack(this);
		});
	}).fail(function( jqxhr, textStatus, error ) {
		var err = textStatus + ", " + error;
		console.log( "Request Failed: " + err );
	});
}

function ckFilterByLang(lang) {
	if (lang == '-1') {
		jQuery('a[data-lang]').show();
		return;
	}
	jQuery('a[data-lang]').hide();
	jQuery('a[data-lang="' + lang + '"]').show();
}

function ckLoadLanguagePack(btn) {
	if (! confirm('Are you sure that you want to install this extension ?')) return;

	btn = jQuery(btn);
	var name = btn.attr('data-name');
	var lang = btn.attr('data-lang').replace('_', '-');
	var project_id = btn.attr('data-project-id');
	var install_url = 'https://translations4.joomlack.fr/index.php?option=com_translationsck&task=package.download&lang=' + lang + '&id=' + project_id;
	jQuery.ajax({
		type: "POST",
		url: "index.php?option=com_extensionsmanagerck&task=ajaxInstallExt",
		data: {
			install_url : install_url
		}
	}).done(function(response) {
		// console.log(response);
		if (response.trim().length) {
			// alert(response);
			$ck('#ckmessagespopup').append(response);
			CKBox.open({handler: 'inline', fullscreen: false
			, content: 'ckmessagespopup'
			, size: {x: '800px', y: '200px'}
			, style: {padding: '10px'}
			,closeText: ''
			,footerHtml: '<a class="ckboxmodal-button" href="javascript:void(0)" onclick="location.reload();">×</a>'});
		} else {
			location.reload();
		}
	}).fail(function( jqxhr, textStatus, error ) {
		var err = textStatus + ", " + error;
		console.log( "Request Failed: " + err );
	});
}